package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.service.delegate.UserServiceDelegate;

import java.util.Iterator;

import junit.framework.TestCase;

import org.tigris.atlas.messages.Message;
import org.tigris.atlas.service.VoidServiceResponse;

public class TestUserServiceValidations extends TestCase {

	UserServiceDelegate delegate = null;
	
	private UserServiceDelegate getDelegate() {
		if( delegate == null ) {
			delegate = ServiceDelegateFactory.createUserServiceDelegate();
		}
		
		return delegate;
	}
	
	public void testUserNameTooShort() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "user", "pass1word#", "pass1word#" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.USERNAME_INVALID_LENGTH, m.getKey() );
	}
	
	public void testUserNameTooLong() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "usernameistoolong", "pass1word#", "pass1word#" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.USERNAME_INVALID_LENGTH, m.getKey() );
	}
	
	public void testUserNameInvalidChar() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "user#$%name", "pass1word#", "pass1word#" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.USERNAME_NOT_ALPHANUMERIC, m.getKey() );
	}
	
	public void testPasswordTooLong() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "pass1word#toolong", "pass1word#toolong" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_INVALID_LENGTH, m.getKey() );
	}
	
	public void testPasswordTooShort() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "p1@", "p1@" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_INVALID_LENGTH, m.getKey() );
	}
	
	public void testCannotConfirmPassword() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "pass1word#", "pass2word#" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_NOT_CONFIRM, m.getKey() );
	}
	
	public void testPasswordHasSpaces() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "pass1 word#", "pass1 word#" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_SPACES_NOT_ALLOWED, m.getKey() );
	}
	
	public void testPasswordNoLetters() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "123!@#456", "123!@#456" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_NO_LETTER, m.getKey() );
	}
	
	public void testPasswordNoDigits() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "abc!@#def", "abc!@#def" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_NO_DIGIT, m.getKey() );
	}
	
	public void testPasswordNoSpecialChars() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "abc123def", "abc123def" );
		Message m = (Message) response.getMessages().getErrorMessages().iterator().next();
		assertEquals( UserManagementMessages.PASSWORD_NO_SPECIAL_CHAR, m.getKey() );
	}
	
	public void testPasswordEqualsUserName() throws Exception {
		VoidServiceResponse response = getDelegate().createUser( "username", "username", "username" );
		Iterator messages = response.getMessages().getErrorMessages().iterator();
		while( messages.hasNext() ) {
			Message m = (Message) messages.next();
			if( UserManagementMessages.USERNAME_PASSWORD_EQUAL.equals( m.getKey() ) ) {
				return;
			}
		}
		
		fail( );
	}

}
